// check to see if we are in a widget
if(window.widget)
{
    // load the preferences for the four buttons
    var commandKeyOne = widget.preferenceForKey("buttonOne");
    var commandKeyTwo = widget.preferenceForKey("buttonTwo");
    var commandKeyThree = widget.preferenceForKey("buttonThree");
    var commandKeyFour = widget.preferenceForKey("buttonFour");
    
    // if the preferences did not exists we will set them here
    if(commandKeyOne == undefined)
        commandKeyOne = "/usr/bin/w";
    if(commandKeyTwo == undefined)
        commandKeyTwo = "/usr/sbin/netstat -m";
    if(commandKeyThree == undefined)
        commandKeyThree = "/sbin/ifconfig";
    if(commandKeyFour == undefined)
        commandKeyFour = "/bin/df -h";
}

function setup()
{
    Anzeige.Output.value = "QuickCommand v0.1\nhttp://www.geisterstunde.org/quickcmd.html";
    mapButtons();
}

function mapButtons() {
    Anzeige.Button1.value = commandKeyOne;
    Anzeige.Button2.value = commandKeyTwo;
    Anzeige.Button3.value = commandKeyThree;
    Anzeige.Button4.value = commandKeyFour;
}

// this whole bunch is just because of the fading info stuff
// taken from: file:///Developer/ADC Reference Library/documentation/AppleApplications/Conceptual/Dashboard_Tutorial/index.html#//apple_ref/doc/uid/TP40001340
var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};
function mousemove (event)
{
    if (!flipShown)
    {
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
                
        var starttime = (new Date).getTime() - 13;
                
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 1.0;
        animate();
        flipShown = true;
    }
}
function mouseexit (event)
{
    if (flipShown)
    {
        // fade in the info button
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
                
        var starttime = (new Date).getTime() - 13;
                
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 0.0;
        animate();
        flipShown = false;
    }
}
function animate()
{
    var T;
    var ease;
    var time = (new Date).getTime();
                
        
    T = limit_3(time-animation.starttime, 0, animation.duration);
        
    if (T >= animation.duration)
    {
        clearInterval (animation.timer);
        animation.timer = null;
        animation.now = animation.to;
    }
    else
    {
        ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
        animation.now = computeNextFloat (animation.from, animation.to, ease);
    }
        
    animation.firstElement.style.opacity = animation.now;
}
function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}
function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}
// done with the animation stuff


// this executes the different commands on the machine
function commandOne() {
    var obj = widget.system(commandKeyOne, null);
    Anzeige.Output.value = commandKeyOne + '\n' + obj.outputString;
}
function commandTwo() {
    var obj = widget.system(commandKeyTwo,null);
    Anzeige.Output.value = commandKeyTwo + '\n' + obj.outputString;
}
function commandThree() {
    var obj = widget.system(commandKeyThree,null);
    Anzeige.Output.value = commandKeyThree + '\n' + obj.outputString;
}
function commandFour() {
    var obj = widget.system(commandKeyFour,null);
    Anzeige.Output.value = commandKeyFour + '\n' + obj.outputString;
}

// this shows the preferences (again taken from the ADC documentation)
function showPrefs()
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");
        
    if (window.widget)
        widget.prepareForTransition("ToBack");
                
    front.style.display="none";
    back.style.display="block";
        
    if (window.widget)
        setTimeout ('widget.performTransition();', 0);
        
    // look up the preferences and set the keys into the form
    Preferences.buttonOne.value = commandKeyOne;
    Preferences.buttonTwo.value = commandKeyTwo;
    Preferences.buttonThree.value = commandKeyThree;
    Preferences.buttonFour.value = commandKeyFour;
}

function hidePrefs()
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");
        
    if (window.widget)
        widget.prepareForTransition("ToFront");
                
    back.style.display="none";
    front.style.display="block";
        
    if (window.widget)
        setTimeout ('widget.performTransition();', 0);
        
    // write the commands from the input form into the variables
    commandKeyOne = Preferences.buttonOne.value;
    commandKeyTwo = Preferences.buttonTwo.value;
    commandKeyThree = Preferences.buttonThree.value;
    commandKeyFour = Preferences.buttonFour.value;
    // save them as widget preferences
    widget.setPreferenceForKey(Preferences.buttonOne.value,"buttonOne");
    widget.setPreferenceForKey(Preferences.buttonTwo.value,"buttonTwo");
    widget.setPreferenceForKey(Preferences.buttonThree.value,"buttonThree");
    widget.setPreferenceForKey(Preferences.buttonFour.value,"buttonFour");
    
    mapButtons();
}
